﻿CREATE TABLE IF NOT EXISTS `allowed_urls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referrers` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `polls` (
  `poll_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `bg_color` varchar(6) NOT NULL DEFAULT 'FFFFFF',
  `title_color` varchar(6) NOT NULL DEFAULT '000000',
  `title_show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`poll_id`)
) DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `poll_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `poll_id` (`poll_id`)
) DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `poll_votes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) NOT NULL,
  `option_id` int(10) unsigned NOT NULL,
  `ip` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `poll_id` (`option_id`)
) DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL DEFAULT '12345',
  `template` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
) DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(100) NOT NULL,
  `text` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `label` (`label`),
  KEY `id` (`id`)
) DEFAULT CHARSET=utf8 ;

INSERT INTO `users` (`id`, `username`, `password`) VALUES
(1, 'admin', 'admin');

INSERT INTO `language` (`id`, `label`, `text`) VALUES
(1, 'VERSION', 'v.1.2'),
(2, 'ADMINISTRATION_PANEL', 'Administration Panel'),
(3, 'INSTALLATION_PANEL', 'Installation Panel'),
(4, 'ADMINISTRATION_LOGIN_PANEL', 'Administration Login Panel'),
(5, 'HOME', 'Home'),
(6, 'WEBSITES', 'Websites'),
(7, 'CONFIGURATION', 'Configuration'),
(8, 'LANGUAGE', 'Language'),
(9, 'LOGOUT', 'Logout'),
(10, 'LOGIN', 'Login'),
(11, 'WARNING_LOGOUT', 'Are you sure you want to logout?'),
(12, 'ADD_NEW_POLL', 'Add New Poll'),
(13, 'EDIT_POLL', 'Edit'),
(14, 'DELETE_POLL', 'Delete'),
(15, 'WARNING_DELETE_POLL', 'Are you sure you want to permanently delete this poll?'),
(16, 'PREVIEW_POLL', 'Preview'),
(17, 'POLL_RESULTS', 'Poll Results'),
(18, 'IFRAME', 'Iframe'),
(19, 'PHP_CODE', 'Php Code'),
(20, 'OBJECT', 'Object'),
(21, 'TITLE', 'Title'),
(22, 'DEFINED_WEBSITES', 'Defined Websites'),
(23, 'ADD_NEW_WEBSITE', 'Add New Website'),
(24, 'DELETE_WEBSITE', 'Delete'),
(25, 'WARNING_DELETE_WEBSITE', 'Are you sure you want to permanently delete this web site?'),
(26, 'UPDATE_LANGUAGE', 'Save'),
(27, 'LABEL', 'Label'),
(28, 'TRANSLATED_TEXT', 'Translated Text'),
(29, 'USERNAME', 'Username'),
(30, 'TEMPLATE', 'Template'),
(31, 'USERNAME_PASSWORD', 'Username/Password'),
(32, 'CHANGE_USERNAME', 'Change Username'),
(33, 'CHANGE_PASSWORD', 'Change Password'),
(34, 'EDIT_TITLE', 'Edit Title'),
(35, 'TITLE_COLOR', 'Title Color'),
(36, 'SHOW_TITLE', 'Show Title'),
(37, 'HIDE_TITLE', 'Hide Title'),
(38, 'BG_COLOR', 'Bg Color'),
(39, 'ADD_NEW_OPTION', 'New Option'),
(40, 'WARNING_NO_OPTION', 'There is no option defined for this poll!<br />You have to add at least 2 poll options by clicking new option button!'),
(41, 'WARNING_DELETE_OPTION', 'Are you sure you want to permanently delete this option?'),
(42, 'EXPORT_PDF', 'Pdf'),
(43, 'EXPORT_XML', 'Xml'),
(44, 'EXPORT_CSV', 'Csv'),
(45, 'TOTAL_VOTES', 'Total Votes'),
(46, 'WARNING_STAT_NO_OPTION', 'There is no option defined for this poll!<br />You have to add poll option(s) by clicking edit button from the main page!'),
(47, 'WARNING_STAT_NOT_RATED', 'Not rated yet!');

